---
generated_at: 2026-02-02 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：50-kubeadm certs

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **デフォルト証明書有効期限（1年）**：renewal/パッケージの実装は未読

## 2) 参照した情報（Evidence一覧）

- E-01: `cmd/kubeadm/app/cmd/certs.go` - certsコマンド本体
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 4つのサブコマンド（renew, check-expiration, certificate-key, generate-csr） | E-01 行112-115 | ○ |
| C-02 | エイリアス "certificates" が使用可能 | E-01 行107 Aliases | ○ |
| C-03 | renew allで全証明書を更新 | E-01 行279-311 allCmd | ○ |
| C-04 | renewは有効期限に関係なく無条件実行 | E-01 行57-67 genericCertRenewLongDesc | ○ |
| C-05 | 外部CA検出時は更新不可メッセージ | E-01 行338-340 | ○ |
| C-06 | 証明書未存在時は "MISSING!" 表示 | E-01 行328, 513-516 | ○ |
| C-07 | check-expirationでJSON/YAML出力対応 | E-01 行441 outputFlags | ○ |
| C-08 | certificate-keyでcopycerts.CreateCertificateKey()使用 | E-01 行203 | ○ |
| C-09 | generate-csrで2段階のCSR生成 | E-01 行186-192 | ○ |
| C-10 | getInternalCfgでクラスタ設定取得→デフォルトフォールバック | E-01 行346-373 | ○ |
| C-11 | cert-dirフラグがクラスタ設定を上書き | E-01 行359-362 | ○ |
| C-12 | renew all完了後にコンポーネント再起動メッセージ | E-01 行303 | ○ |
| C-13 | renewサブコマンドは動的生成される | E-01 行252-277 forループ | ○ |
| C-14 | 関連機能121-証明書管理が主機能 | E-03 画面No50 | ○ |
| C-15 | check-expiration出力列（CERTIFICATE, EXPIRES, RESIDUAL TIME, CA, EXTERNALLY MANAGED） | E-01 行511 | ○ |
| C-16 | デフォルト証明書有効期限は1年 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- デフォルト証明書有効期限の値はrenewal/パッケージまたはcertsphaseの実装で定義されており、certs.goからは直接確認できない
  - 候補：cmd/kubeadm/app/phases/certs/ / cmd/kubeadm/app/constants/

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - renewal.Managerの内部実装（証明書の列挙、更新ロジック）が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] renewal/パッケージの証明書更新ロジックを確認
- [ ] デフォルト証明書有効期限が正確か確認
- [ ] 外部CAモードの動作を確認
- [ ] generate-csrの出力ファイル形式を確認
